﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;

namespace AZVIC.Ei8htPOS.DAL
{
    public class ProductColorDB
    {
        public static ProductColor GetItem(Guid productColorID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
                parameters.Add(new SqlParameter("@ProductColorID", ((productColorID != Guid.Empty && productColorID != null) ? productColorID : (object)DBNull.Value)));
                parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

                return SQLHelper.RetrieveObject<ProductColor>("spGetProductColor", parameters);
            
        }

        public static List<ProductColor> GetList(Guid productColorID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
                parameters.Add(new SqlParameter("@ProductColorID", ((productColorID != Guid.Empty && productColorID != null) ? productColorID : (object)DBNull.Value)));
                parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

                return SQLHelper.RetrieveList<ProductColor>("spGetProductColor", parameters);
           
        }

        public static DataTable GetDataTable(Guid productColorID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
                parameters.Add(new SqlParameter("@ProductColorID", ((productColorID != Guid.Empty && productColorID != null) ? productColorID : (object)DBNull.Value)));
                parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

                return SQLHelper.ExecuteDataTable("spGetProductColor", parameters);
            
            
        }

        public static DataSet GetDataSet(Guid productColorID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
                parameters.Add(new SqlParameter("@ProductColorID", ((productColorID != Guid.Empty && productColorID != null) ? productColorID : (object)DBNull.Value)));
                parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

                return SQLHelper.ExecuteDataSet("spGetProductColor", parameters);
            
        }

        public static void Save(ProductColor myProductColor)
        {
            myProductColor.Mode = ((myProductColor.UniqueID != Guid.Empty && myProductColor.UniqueID != null) ? GlobalConfigurations.Mode.Update : GlobalConfigurations.Mode.Insert);
            myProductColor.UniqueID = ((myProductColor.UniqueID != Guid.Empty && myProductColor.UniqueID != null) ? myProductColor.UniqueID : Guid.NewGuid());
            if (myProductColor.Mode == GlobalConfigurations.Mode.Insert)
            {
                myProductColor.IsActive = true;
            }

             List<SqlParameter> parameters = new List<SqlParameter>();
                parameters.Add(new SqlParameter("@ProductColorID", myProductColor.UniqueID));
                parameters.Add(new SqlParameter("@ColorName", (string.IsNullOrEmpty(myProductColor.ColorName) ? (object)DBNull.Value : myProductColor.ColorName)));
                parameters.Add(new SqlParameter("@SequenceNo", (myProductColor.SequenceNo == 0) ? (object)DBNull.Value : myProductColor.SequenceNo));
                parameters.Add(new SqlParameter("@CreatedBy", ((myProductColor.UserAccountID != Guid.Empty && myProductColor.UserAccountID != null) ? myProductColor.UserAccountID : (object)DBNull.Value)));
                parameters.Add(new SqlParameter("@IsActive", myProductColor.IsActive));
                //parameters.Add(new SqlParameter("@IsDeleted", myProductColor.IsDeleted));
                parameters.Add(new SqlParameter("@Mode", myProductColor.Mode));

                SQLHelper.ExecuteQuery("spAddOrUpdateProductColor", parameters);
            
        }
    }
}
